local Players = GAMESTATE:GetHumanPlayers()
local PaneNames = {"General", "PerPanel", "HighScores", "Timing", "FAPlus", "Achievements", "TestInput", "GSQR", "GeneralITG"}

local playerstats = {}

-- keep track of panes using tables per player
WF.EvalPanes = {}
WF.DefaultPane = {}
WF.ActivePane = {}
if not WF.ITGCentricPanes then
	WF.ITGCentricPanes = {"GSQR", "GeneralITG"}
end

-- generate hashes once, and pass them down to other things that need them
local hashes = {}

--- update song stats, initialize some stuff
for player in ivalues(Players) do
	local pn = tonumber(player:sub(-1))

	-- songs played
	WF.CurrentSessionSongsPlayed[pn] = WF.CurrentSessionSongsPlayed[pn] + 1

	-- itg stuff [TODO] eventually might just store the score before getting here. not sure.
	WF.ConsolidateJudgments(pn)
	WF.CalculateITGScore(player)

	-- consolidate per panel
	local detailed = SL["P"..pn].Stages.Stats[SL.Global.Stages.PlayedThisGame + 1].detailed_judgments
	WF.ConsolidatePerPanelJudgments(pn, detailed)

	-- update song stats
	local lifevals = WF.GetShortLifeBarTable(pn)
	local stats = WF.BuildStatsObj(STATSMAN:GetCurStageStats():GetPlayerStageStats(player), lifevals)
	WF.CurrentSongStatsObject[pn] = stats
	playerstats[pn] = stats -- we can pass this down to other actors that might need to use it
	local song = GAMESTATE:GetCurrentSong()
	local steps = GAMESTATE:GetCurrentSteps(player)
	local profile = PROFILEMAN:GetProfile(player)

	-- get hashes
	local steps = GAMESTATE:GetCurrentSteps(player)
	local diff = ToEnumShortString(steps:GetDifficulty())
	local stype = steps:GetStepsType():gsub("StepsType_",""):lower():gsub("_", "-")
	hashes[pn] = GenerateHash(steps, stype, diff)

	-- high score copies
	local rate = RateFromNumber(SL.Global.ActiveModifiers.MusicRate)
	local songstats = WF.FindProfileSongStatsFromSteps(song, steps, rate, hashes[pn], pn)

	WF.EvalPanes[pn] = {}
	WF.DefaultPane[pn] = (not SL["P"..pn].ActiveModifiers.SimulateITGEnv) and "General" or "GeneralITG"
	WF.ActivePane[pn] = 1 -- this will be set to the "true" index of DefaultPane below if it isn't 1
end

-- evaluate all profile stuff
-- see WF-Profiles.lua for the data structure returned here
local hsdata = WF.UpdateProfilesOnEvaluation(hashes)

-- Start by loading actors that would be the same whether 1 or 2 players are joined.
local t = Def.ActorFrame{

	-- add a lua-based InputCalllback to this screen so that we can navigate
	-- through multiple panes of information; pass a reference to this ActorFrame
	-- and the number of panes there are to InputHandler.lua
	OnCommand=function(self)
		SCREENMAN:GetTopScreen():AddInputCallback( LoadActor("./InputHandler.lua", {af=self, num_panes=NumPanes}) )
	end,

	-- code for triggering a screenshot and animating a "screenshot" texture
	LoadActor("./ScreenshotHandler.lua"),

	-- the song info and its graphical banner, if there is one
	LoadActor("./TitleAndBanner.lua"),

	-- store some attributes of this playthrough of this song in the global SL table
	-- for later retrieval on ScreenEvaluationSummary
	LoadActor("./GlobalStorage.lua"),
}



-- Then, load the player-specific actors.
for player in ivalues(Players) do
	local pn = tonumber(player:sub(-1))

	-- the upper half of ScreenEvaluation
	t[#t+1] = Def.ActorFrame{
		Name=ToEnumShortString(player).."_AF_Upper",
		OnCommand=function(self)
			if player == PLAYER_1 then
				self:x(_screen.cx - 155)
			elseif player == PLAYER_2 then
				self:x(_screen.cx + 155)
			end
		end,

		-- store player stats for later retrieval on EvaluationSummary and NameEntryTraditional
		LoadActor("./PerPlayer/Storage.lua", {player = player, stats = playerstats[pn]}),

		-- letter grade
		LoadActor("./PerPlayer/LetterGrade.lua", {player=player, stats=playerstats[pn]})..{
			Name = "LetterGrade",
			InitCommand = function(self)
				self:x(WideScale(2,34) * (player==PLAYER_1 and -1 or 1))
				self:y(_screen.cy-144)
				if FindInTable(WF.DefaultPane[pn], WF.ITGCentricPanes) then
					self:zoom(0)
				end
			end,
			EvalPaneChangedMessageCommand = function(self, args)
				if args.pn ~= pn then return end
				self:finishtweening()
				local pane = WF.EvalPanes[pn][args.activepane]
				if pane and FindInTable(pane:GetName(), WF.ITGCentricPanes) then
					self:queuecommand("Hide")
				else
					self:queuecommand("Show")
				end
			end,
			ShowCommand = function(self)
				self:linear(0.08)
				self:zoom(1)
			end,
			HideCommand = function(self)
				self:linear(0.08)
				self:zoom(0)
			end
		},

		-- itg grade
		LoadActor("./PerPlayer/ITGGrade.lua", player)..{
			Name = "ITGGrade",
			InitCommand = function(self)
				self:x(WideScale(2,34) * (player==PLAYER_1 and -1 or 1))
				self:y(_screen.cy-144)
				if not FindInTable(WF.DefaultPane[pn], WF.ITGCentricPanes) then
					self:zoom(0)
				end
			end,
			EvalPaneChangedMessageCommand = function(self, args)
				if args.pn ~= pn then return end
				self:finishtweening()
				local pane = WF.EvalPanes[pn][args.activepane]
				if pane and (not FindInTable(pane:GetName(), WF.ITGCentricPanes)) then
					self:queuecommand("Hide")
				else
					self:queuecommand("Show")
				end
			end,
			ShowCommand = function(self)
				self:linear(0.08)
				self:zoom(1)
			end,
			HideCommand = function(self)
				self:linear(0.08)
				self:zoom(0)
			end
		},

		-- profile card
		LoadActor(THEME:GetPathG("", "_profilecard/profilecard.lua"), {player = player, 
			loweraf = WF.ProfileCardLowerAF(pn)})..{
			InitCommand = function(self) self:xy((player == PLAYER_1 and -1 or 1) * WideScale(104,168),100) end
		},

		-- temporary: cleartype text
		Def.Quad{
			Name = "CTBack",
			InitCommand = function(self)
				self:xy(WideScale(2,34) * (player==PLAYER_1 and -1 or 1),_screen.cy - 104)
					:zoomto(90,16):diffuse(0,0,0,0.8)
				if FindInTable(WF.DefaultPane[pn], WF.ITGCentricPanes) then
					self:diffusealpha(0)
				end
			end,
			EvalPaneChangedMessageCommand = function(self, args)
				if args.pn ~= pn then return end
				self:finishtweening()
				local pane = WF.EvalPanes[pn][args.activepane]
				if pane and FindInTable(pane:GetName(),WF.ITGCentricPanes) then
					self:queuecommand("Hide")
				else
					self:queuecommand("Show")
				end
			end,
			ShowCommand = function(self)
				self:linear(0.08)
				self:diffusealpha(0.8)
			end,
			HideCommand = function(self)
				self:linear(0.08)
				self:diffusealpha(0)
			end
		},
		LoadFont("Common Normal")..{
			Name = "CTText",
			Text = "",
			InitCommand = function(self)
				self:x(WideScale(2,34) * (player==PLAYER_1 and -1 or 1))
				self:y(_screen.cy - 104)
				self:zoom(0.75)
				local ct = playerstats[pn]:GetClearType()
				if ct == WF.ClearTypes.Fail then
					local s = playerstats[pn]:GetSkipped() and " (skipped)" or ""
					self:settext("Failed"..s)
					self:diffuse(1,0,0,1)
				else
					self:settext(WF.ClearTypes[ct])
					if ct <= 4 then
						-- full combo tiers. colorize to judgment color.
						self:diffuse(SL.JudgmentColors["Waterfall"][ct])
					else
						-- lifebar clear tiers. colorize to lifebar color.
						local c = WF.LifeBarColors[4 - (ct - 4)]
						self:diffuse(c[1],c[2],c[3],1)
					end
				end
				if FindInTable(WF.DefaultPane[pn], WF.ITGCentricPanes) then
					self:diffusealpha(0)
				end
			end,
			EvalPaneChangedMessageCommand = function(self, args)
				if args.pn ~= pn then return end
				self:finishtweening()
				local pane = WF.EvalPanes[pn][args.activepane]
				if pane and FindInTable(pane:GetName(),WF.ITGCentricPanes) then
					self:queuecommand("Hide")
				else
					self:queuecommand("Show")
				end
			end,
			ShowCommand = function(self)
				self:linear(0.08)
				self:diffusealpha(1)
			end,
			HideCommand = function(self)
				self:linear(0.08)
				self:diffusealpha(0)
			end
		},

		-- chart info
		LoadActor("./PerPlayer/ChartInfo.lua", player),

		-- Record Texts (Machine and/or Personal)
		LoadActor("./PerPlayer/RecordTexts.lua", {player = player, hsdata = hsdata[pn]})
	}

	-- the lower half of ScreenEvaluation
	local lower = Def.ActorFrame{
		Name=ToEnumShortString(player).."_AF_Lower",
		OnCommand=function(self)
			-- if double style, center the gameplay stats
			if GAMESTATE:GetCurrentStyle():GetStyleType() == "StyleType_OnePlayerTwoSides" then
				self:x(_screen.cx)
			else
				self:x(_screen.cx + (player==PLAYER_1 and -155 or 155))
			end

			-- move lower part down a litle
			self:y(32)

			-- add all panes to EvalPanes table
			local defp
			for name in ivalues(PaneNames) do
				local pane = self:GetChild(name)
				if pane then
					table.insert(WF.EvalPanes[pn], pane)
					pane:visible(false)
					if pane:GetName() == WF.DefaultPane[pn] then
						pane:visible(true)
						defp = pane
					end
				end
			end
			if defp then
				WF.ActivePane[pn] = FindInTable(defp, WF.EvalPanes[pn])
			end
		end,

		-- background quad for player stats
		Def.Quad{
			Name="LowerQuad",
			InitCommand=function(self)
				self:diffuse(color("#1E282F")):y(_screen.cy+34):zoomto( 300,180 )
			end,
			-- this background Quad may need to shrink and expand if we're playing double
			-- and need more space to accommodate more columns of arrows;  these commands
			-- are queued as needed from the InputHandler
			ShrinkCommand=function(self)
				self:zoomto(300,180):x(0)
			end,
			ExpandCommand=function(self)
				self:zoomto(520,180):x(3)
			end
		},

		-- "Look at this graph."  –Some sort of meme on The Internet
		LoadActor("./PerPlayer/Graphs.lua", player),

		-- list of modifiers used by this player for this song
		-- [TODO] this will be displayed in a different way
		--LoadActor("./PerPlayer/PlayerModifiers.lua", player),

		-- little rectangle at the bottom of the graphs
		Def.Quad{
			InitCommand=function(self)
				self:diffuse(color("#1E282F")):y(_screen.cy+188):vertalign("top"):zoomto(300, 8)
			end
		}
	}

	-- add available Panes to the lower ActorFrame via a loop
	-- Note(teejusb): Some of these actors may be nil. This is not a bug, but
	-- a feature for any panes we want to be conditional (e.g. the QR code).
	for name in ivalues(PaneNames) do
		local arg = player
		if name == "GSQR" then
			arg = {player = player, hash = hashes[pn]}
		elseif name == "HighScores" or name == "Achievements" then
			arg = {player = player, hsdata = hsdata}
		end
		local pane = LoadActor("./PerPlayer/"..name, arg)
		if pane then
			pane.ShowCommand = function(self)
				self:visible(true)
			end
			pane.HideCommand = function(self)
				self:visible(false)
			end
			lower[#lower+1] = pane
		end
	end

	-- add lower ActorFrame to the primary ActorFrame
	t[#t+1] = lower
end


return t